/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\fH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/json/internal/JsonTreeDecoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeDecoder;", "json", "Lkotlinx/serialization/json/Json;", "value", "Lkotlinx/serialization/json/JsonObject;", "polyDiscriminator", "", "polyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "position", "", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "coerceInputValue", "", "index", "tag", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "decodeElementIndex", "elementName", "desc", "endStructure", "", "kotlinx-serialization-json"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    @NotNull
    private final JsonObject value;
    @Nullable
    private final String polyDiscriminator;
    @Nullable
    private final SerialDescriptor polyDescriptor;
    private int position;

    public JsonTreeDecoder(@NotNull Json json, @NotNull JsonObject value, @Nullable String polyDiscriminator, @Nullable SerialDescriptor polyDescriptor) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(value, "value");
        super(json, value, null);
        this.value = value;
        this.polyDiscriminator = polyDiscriminator;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    @NotNull
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index, String tag) {
        void $this$tryCoerceValue_u24default$iv;
        String string;
        void elementDescriptor$iv;
        Json json = this.getJson();
        SerialDescriptor serialDescriptor = descriptor2.getElementDescriptor(index);
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor$iv.isNullable()) {
            boolean bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        boolean bl = false;
        JsonElement jsonElement = this.currentElement(tag);
        if (!(jsonElement instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        JsonPrimitive jsonPrimitive2 = jsonPrimitive;
        if (jsonPrimitive2 == null) {
            return false;
        }
        String string2 = string = JsonElementKt.getContentOrNull(jsonPrimitive2);
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex((SerialDescriptor)elementDescriptor$iv, (Json)$this$tryCoerceValue_u24default$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        return true;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        while (this.position < descriptor2.getElementsCount()) {
            Object object = this;
            int n = ((JsonTreeDecoder)object).position;
            ((JsonTreeDecoder)object).position = n + 1;
            String name = this.getTag(descriptor2, n);
            object = this.getValue();
            n = 0;
            Object object2 = object;
            boolean bl = false;
            if (!object2.containsKey(name) || this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, this.position - 1, name)) continue;
            return this.position - 1;
        }
        return -1;
    }

    @Override
    @NotNull
    protected String elementName(@NotNull SerialDescriptor desc, int index) {
        Object v1;
        Object object;
        String mainName;
        block3: {
            Intrinsics.checkNotNullParameter(desc, "desc");
            mainName = desc.getElementName(index);
            if (!this.configuration.getUseAlternativeNames()) {
                return mainName;
            }
            if (this.getValue().keySet().contains(mainName)) {
                return mainName;
            }
            Map<String, Integer> alternativeNamesMap2 = JsonSchemaCacheKt.getSchemaCache(this.getJson()).getOrPut(desc, JsonNamesMapKt.getJsonAlternativeNamesKey(), (Function0)new Function0<Map<String, ? extends Integer>>(desc){

                @NotNull
                public final Map<String, Integer> invoke() {
                    return JsonNamesMapKt.buildAlternativeNamesMap((SerialDescriptor)this.receiver);
                }
            });
            object = this.getValue().keySet();
            boolean bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl3 = false;
                Integer n = alternativeNamesMap2.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        String nameInObject = v1;
        object = nameInObject;
        return object == null ? mainName : object;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        return (JsonElement)MapsKt.getValue(this.getValue(), tag);
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2 == this.polyDescriptor) {
            return this;
        }
        return super.beginStructure(descriptor2);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Set<String> set;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.configuration.getIgnoreUnknownKeys() || descriptor2.getKind() instanceof PolymorphicKind) {
            return;
        }
        if (!this.configuration.getUseAlternativeNames()) {
            set = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor2);
        } else {
            Set<String> set2 = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor2);
            Object object = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor2, JsonNamesMapKt.getJsonAlternativeNamesKey());
            object = object == null ? null : object.keySet();
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                object2 = SetsKt.emptySet();
            }
            set = SetsKt.plus(set2, (Iterable)object2);
        }
        Set<String> names = set;
        for (String key : this.getValue().keySet()) {
            if (names.contains(key) || Intrinsics.areEqual(key, this.polyDiscriminator)) continue;
            throw JsonExceptionsKt.UnknownKeyException(key, this.getValue().toString());
        }
    }
}

